package fr.asip.cps3.exemple.vues.ecrans;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import fr.asip.cps3.exemple.vues.composants.StyleCellule;

/**
 * Classe utilitaire pour assister la construction des crans
 */
public class EcranUtil {

	/*######################*/
	/* CONSTANTES GENERALES */
	/*######################*/
	public static final int TYPE_ECRAN_AUTHENTIFICATION_SO = 1;
	public static final int TYPE_ECRAN_AUTHENTIFICATION_UTILISATEUR = 2;
	public static final int TYPE_ECRAN_INIT_CODE_PORTEUR = 3;
	public static final int TYPE_ECRAN_MODIF_CODE_PORTEUR = 4;
	public static final int TYPE_ECRAN_GENERATION_AVEC_SEED = 5;
	public static final int TYPE_ECRAN_GENERATION_EMPREINTE_MESSAGE = 6;
	public static final int TYPE_ECRAN_GENERATION_EMPREINTE_FICHIER = 7;
	public static final int TYPE_ECRAN_GENERATION_SIGNATURE_MESSAGE = 8;
	public static final int TYPE_ECRAN_GENERATION_SIGNATURE_FICHIER = 9;
	public static final int TYPE_ECRAN_VERIFICATION_SIGNATURE_MESSAGE = 10;
	public static final int TYPE_ECRAN_VERIFICATION_SIGNATURE_FICHIER = 11;
	public static final int TYPE_ECRAN_CREATION_OBJETS = 12;
	public static final int TYPE_ECRAN_MODIFICATION_OBJETS = 13;
	public static final int TYPE_ECRAN_RECHERCHE_OBJETS = 14;
	
	/*########*/
	/* INSETS */
	/*########*/
	public static final Insets cellInsets = new Insets(2, 2, 2, 2); // Objet Insets pour la gestion des bordures
	
	/*##############*/
	/* BARRE STATUT */
	/*##############*/
	
	// Style de cellule pour la barre de statut
	public static final StyleCellule styleBarreStatut = new StyleCellule(0.0, 0.0,GridBagConstraints.PAGE_END, GridBagConstraints.HORIZONTAL,cellInsets, 2, 0);

	/*##############*/
	/* CHAMPS TEXTE */
	/*##############*/
	public static final StyleCellule styleChampTexteSaisie = new StyleCellule(0.5, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.NONE,cellInsets, 2, 0);
	public static final StyleCellule styleChampTexteSaisie2 = new StyleCellule(0.0, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.NONE,cellInsets, 2, 0);
	public static final StyleCellule styleChampTexteFichier = new StyleCellule(1.0, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.HORIZONTAL,cellInsets, 2, 0);
	public static final StyleCellule styleChampTexteLibelleObjet = new StyleCellule(1.0, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.HORIZONTAL,cellInsets, 2, 0);
	
	/*##########*/
	/* LIBELLES */
	/*##########*/
	public static final StyleCellule styleLibelleSaisie = new StyleCellule(0.5, 0.0,GridBagConstraints.LINE_END, GridBagConstraints.NONE, cellInsets, 2, 0);
	public static final StyleCellule styleLibelleSaisieFichier = new StyleCellule(0.0, 0.0,GridBagConstraints.LINE_END, GridBagConstraints.NONE, cellInsets, 2, 0);	
	public static final StyleCellule styleLibelleSaisieMessage = new StyleCellule(0.0, 0.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.NONE, cellInsets, 2, 0);	
	public static final StyleCellule styleLibelleStatutPIN = new StyleCellule(0.5, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.NONE, cellInsets,0, 0);
	public static final StyleCellule styleLibelleSortieCodeRetour = new StyleCellule(0.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.NONE, cellInsets, 2, 4);	
	public static final StyleCellule styleLibelleSaisieObjet = new StyleCellule(0.0, 0.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.NONE, cellInsets, 2, 0);	
	public static final StyleCellule styleLibelleSaisieSignature = new StyleCellule(0.0, 0.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.NONE, cellInsets, 2, 0);	
	public static final StyleCellule styleLibelleSaisieSignatureFichier = new StyleCellule(0.0, 0.0,GridBagConstraints.FIRST_LINE_END, GridBagConstraints.NONE, cellInsets, 2, 0);	
	public static final StyleCellule styleLibelleSortie = new StyleCellule(0.0, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);
	public static final StyleCellule styleLibelleLigneEntiere = new StyleCellule(0.0, 0.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);
	
	public static final StyleCellule styleLibelleDialogLigneEntiere = new StyleCellule(0.5, 0.0,GridBagConstraints.CENTER, GridBagConstraints.NONE, cellInsets, 2, 0);	
	
	/*###########*/
	/* TEXTAREAS */
	/*###########*/
	public static final StyleCellule styleTexteSortie = new StyleCellule(0.0, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);		
	public static final StyleCellule styleTexteSortieCodeRetour = new StyleCellule(1.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.HORIZONTAL, cellInsets, 2, 0);	
	
	public static final StyleCellule styleTexteDialog = new StyleCellule(0.5, 0.0,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, cellInsets, 2, 0);
	
	/*#########*/
	/* SCROLLS */
	/*#########*/
	public static final StyleCellule styleScrollInfos = new StyleCellule(1.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);	
	public static final StyleCellule styleScrollEmpreinte = new StyleCellule(1.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);	
	public static final StyleCellule styleScrollSaisieMessage = new StyleCellule(1.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);
	public static final StyleCellule styleScrollSaisieObjet = new StyleCellule(1.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);	
	public static final StyleCellule styleScrollSaisieSignature = new StyleCellule(1.0, 1.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.BOTH, cellInsets, 2, 0);	

	/*#########*/
	/* BOUTONS */
	/*#########*/
	public static final StyleCellule styleBoutonSoumettre = new StyleCellule(0.0, 1.0,GridBagConstraints.PAGE_START, GridBagConstraints.NONE, cellInsets,0, 0);
	public static final StyleCellule styleBoutonParcourir = new StyleCellule(0.0, 0.0,GridBagConstraints.FIRST_LINE_START, GridBagConstraints.NONE, cellInsets,0, 0);	

	public static final StyleCellule styleBoutonDialogAnnuler = new StyleCellule(1.0, 0.0,GridBagConstraints.LINE_START, GridBagConstraints.NONE, cellInsets,0, 0);
	public static final StyleCellule styleBoutonDialogValider = new StyleCellule(1.0, 0.0,GridBagConstraints.LINE_END, GridBagConstraints.NONE, cellInsets,0, 0);		
	
	/*##########*/
	/* METHODES */
	/*##########*/	
	/**
	 * Nettoyage explicite du panel
	 * @param panel Panel  nettoyer
	 */
	public static void supprimeTousLesComposants(JPanel panel){
		
		Component[] components = panel.getComponents();
		for (int i = 0; i < components.length; i++) {
			panel.remove(components[i]);
		}
		panel.revalidate();
		panel.repaint();
		
	}
	
}
